<?php
require_once("../layouts/members/head.php");

/* =========================
   NEW PAN FIND API FUNCTION
   ========================= */
function panfind_run_new($request)
{
    $aadhaar = $request['aadhaar'];
    $api_key = "APIKEYPASTEED"; // 🔥 REPLACE WITH YOUR API KEY // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )

    $url = "https://kycapizone.in/api/panno/instant/aadhaar_to_pan.php"
         . "?api_key={$api_key}&aadhaar_no={$aadhaar}";

    $curl = curl_init();
    curl_setopt_array($curl, array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 30,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => 'GET',
    ));

    $response = curl_exec($curl);
    curl_close($curl);

    $res = json_decode($response, true);

    // ✅ ONLY STATUS CODE CHECK (SAFE)
    if (isset($res['status_code']) && (int)$res['status_code'] === 100) {
        return [
            'status'    => '100',
            'panNumber' => $res['data']['pan_number'] ?? '',
            'uid'       => $res['data']['aadhaar_number'] ?? '',
        ];
    } else {
        return [
            'status' => '101',
            'error'  => $res['message'] ?? 'API Error'
        ];
    }
}

/* =========================
   MAIN PAGE
   ========================= */

$aadhaar  = '';
$response = [];

if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
<?php if ($user_data['pandfind_service'] == "YES") { ?>
<div class="col-md-4 mb-2">
<div class="card text-danger">
<div class="card-header bg-primary text-white py-2">
<div class="d-flex align-items-center">
<span class="mr-auto"><?= file_name() ?></span>
<button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
<i class="fas fa-arrow-left"></i> Back
</button>
</div>
</div>

<div class="p-3 text-dark">
<?php
if (isset($_POST['submit'])) {

    $aadhaar = is_valid_aadhaar($_POST['aadhaar']);

    if (!empty($aadhaar)) {

        $amount      = $user_data['pan_find_fee'];
        $old_balance = $user_data['balance'];
        $new_balance = $old_balance - $amount;

        if ($old_balance >= $amount) {

            $order_id = order_txn_id();

            // 🔥 USE NEW FUNCTION HERE
            $response = panfind_run_new([
                'aadhaar'  => $aadhaar,
                'order_id'=> $order_id
            ]);

            if (isset($response['status']) && $response['status'] == '100') {

                db_update(
                    "members",
                    ["balance" => $new_balance],
                    " user_id='{$user_data['user_id']}' "
                );

                db_insert("reports", [
                    'site_id'        => $site_data['site_id'],
                    'user_id'        => $user_data['user_id'],
                    'username'       => $user_data['username'],
                    'name'           => $user_data['name'],
                    'operator'       => $user_data['usertype'],
                    'parent_id'      => $user_data['parent_id'],
                    'order_id'       => $order_id,
                    'service'        => "PANFIND",
                    'type'           => "Debit",
                    'account_number' => $aadhaar,
                    'app_type'       => "PANFIND",
                    'amount'         => $amount,
                    'main_amount'    => $amount,
                    'old_balance'    => $old_balance,
                    'new_balance'    => $new_balance,
                    'txn_id'         => $order_id,
                    'ref_id'         => $response['panNumber'],
                    'description'    => "Rs.{$amount} Debited for PAN Find {$aadhaar}",
                    'date_time'      => current_timestamp(),
                    'status'         => "Success"
                ]);

                send_sms(
                    $user_data['mobile'],
                    "Dear {$user_data['name']},\nPAN Found Successfully.\n\nPAN: {$response['panNumber']}\nAadhaar: {$response['uid']}\n\n{$site_data['brand']}"
                );

            } else {
                awal_alert_msg($response['error'], 'error');
            }

        } else {
            awal_alert_msg("Insufficient Wallet Balance!", 'error');
        }
    } else {
        awal_alert_msg("Invalid Aadhaar!", 'error');
    }
}
?>

<form method="POST" class="row">
<div class="col-md-12 mb-3">
<label>Aadhaar Number</label>
<input type="number" name="aadhaar" class="form-control"
maxlength="12"
onkeypress="if(this.value.length==12) return false;"
required>
</div>

<div class="col-md-12 mb-3 d-flex justify-content-between">
<button type="button" class="btn btn-secondary">
<i class="fas fa-inr"></i> <?= $user_data['pan_find_fee']; ?>
</button>

<button type="submit" name="submit" class="btn btn-primary"
onclick="return confirm('Are you sure?');">
Submit
</button>

<button type="button" class="btn btn-warning"
data-toggle="modal" data-target="#showDetailsModal">
Show
</button>
</div>
</form>
</div>
</div>
</div>
<?php } ?>
</div>

<!-- MODAL -->
<div class="modal fade" id="showDetailsModal">
<div class="modal-dialog">
<div class="modal-content">
<div class="modal-header">
<h5 class="modal-title">Fetched Details</h5>
<button class="close" data-dismiss="modal">&times;</button>
</div>
<div class="modal-body">
<?php if (!empty($response['panNumber'])) { ?>
<input class="form-control mb-2" value="<?= htmlspecialchars($aadhaar) ?>" readonly>
<input class="form-control" value="<?= htmlspecialchars($response['panNumber']) ?>" readonly>
<?php } else { ?>
<p>No data fetched.</p>
<?php } ?>
</div>
</div>
</div>
</div>

<script>
<?php if (!empty($response['panNumber'])) { ?>
$(document).ready(function(){
    $('#showDetailsModal').modal('show');
});
<?php } ?>
</script>

<?php
} else {
require_once("404.php");
}
require_once("../layouts/members/foot.php");
?>
